---
title: Error 1035 · Cloudflare Support docs
description: This error indicates an invalid URI path in a request rewrite.
lastUpdated: 2025-05-14T13:30:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1035/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1035/index.md
---

## Error 1035: Invalid request rewrite (invalid URI path)

This error indicates an invalid URI path in a request rewrite.

### Common cause

The value or expression of your rewritten URI path is not valid.

This error also occurs when the destination of the URL rewrite is a path under `/cdn-cgi/`.

### Resolution

Make sure that the rewritten URI path is not empty and it starts with a `/` (slash) character.

For example, the following URI path rewrite expression is not valid:

`concat(lower(ip.src.country), http.request.uri.path)`

To fix the expression above, add a `/` prefix:

`concat("/", lower(ip.src.country), http.request.uri.path)`
