---
title: Email Address Obfuscation · Cloudflare Web Application Firewall (WAF) docs
description: By enabling Cloudflare Email Address Obfuscation, email addresses
  on your web page will be hidden from bots, while keeping them visible to
  humans. In fact, there are no visible changes to your website for visitors.
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/
  md: https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/index.md
---

By enabling Cloudflare Email Address Obfuscation, email addresses on your web page will be hidden from bots, while keeping them visible to humans. In fact, there are no visible changes to your website for visitors.

## Background

Email harvesters and other bots roam the Internet looking for email addresses to add to lists that target recipients for spam. This trend results in an increasing amount of unwanted email.

Web administrators have come up with clever ways to protect against this by writing out email addresses, such as `help [at] cloudflare [dot] com` or by using embedded images of the email address. However, you lose the convenience of clicking on the email address to automatically send an email. By enabling Cloudflare Email Address Obfuscation, email addresses on your web page will be obfuscated (hidden) from bots, while keeping them visible to humans. In fact, there are no visible changes to your website for visitors.

## How it works

When Email Address Obfuscation is enabled, Cloudflare replaces visible email addresses in your HTML with links like `[email protected]`. If a visitor sees this obfuscated format, they can click the link to reveal the actual email address. This approach prevents bots from scraping email addresses while keeping them accessible to real users.

## Change Email Address Obfuscation setting

Cloudflare enables email address obfuscation automatically when you sign up.

* Dashboard

  To disable **Email Address Obfuscation** in the dashboard:

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com/login).
  2. Select your account and website.
  3. Go to **Scrape Shield**.
  4. For **Email Address Obfuscation**, switch the toggle to **Off**.

* API

  To disable **Email Address Obfuscation** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `email_obfuscation` as the setting name in the URI path, and the `value` parameter set to `"off"`.

Note

To use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).

## Prevent Cloudflare from obfuscating email

To prevent Cloudflare from obfuscating specific email addresses, you can:

* Add the following comment in the page HTML code:

  ```plaintext
  <!--email_off-->contact@example.com<!--/email_off-->
  ```

* Return email addresses in JSON format for AJAX calls, making sure your web server returns a content type of `application/json`.

* Disable the Email Obfuscation feature by creating a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/) to be applied on a specific endpoint.

***

## Troubleshoot email obfuscation

To prevent unexpected website behavior, email addresses are not obfuscated when they appear in:

* Any HTML tag attribute, except for the *href* attribute of the *a* tag.

* Other HTML tags:

  * *script* tags: `<script></script>`
  * *noscript* tags: `<noscript></noscript>`
  * *textarea* tags: `<textarea></textarea>`
  * *xmp* tags: `<xmp></xmp>`
  * *head* tags: `<head></head>`

* Any page that does not have a MIME type of `text/html` or `application/xhtml+xml`.

Note

Email Obfuscation will not apply in the following cases:

* You are using the `Cache-Control: no-transform` header.
* The HTML/JS code is specifically added by a [Worker](https://developers.cloudflare.com/workers/).
