---
title: Workers Changelog · Cloudflare Workers docs
description: Review recent changes to Cloudflare Workers.
lastUpdated: 2025-02-13T19:35:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/platform/changelog/
  md: https://developers.cloudflare.com/workers/platform/changelog/index.md
---

This changelog details meaningful changes made to Workers across the Cloudflare dashboard, Wrangler, the API, and the workerd runtime. These changes are not configurable.

This is *different* from [compatibility dates](https://developers.cloudflare.com/workers/configuration/compatibility-dates/) and [compatibility flags](https://developers.cloudflare.com/workers/configuration/compatibility-flags/), which let you explicitly opt-in to or opt-out of specific changes to the Workers Runtime.

[Subscribe to RSS](https://developers.cloudflare.com/workers/platform/changelog/index.xml)

## 2025-09-18

* Updated v8 to version 14.1.

## 2025-08-21

* Updated v8 to version 14.0.
* `Uint8Array` type in JavaScript now supports base64 and hex operations.

## 2025-08-14

* Enable V8 Sandbox for improved isolation and security.

## 2025-08-11

* The MessageChannel and MessagePort APIs are now available in Workers.

## 2025-06-27

* Updated v8 to version 13.9.

## 2025-06-23

* Enable FinalizationRegistry API. See [We shipped FinalizationRegistry in Workers: why you should never use it](https://blog.cloudflare.com/we-shipped-finalizationregistry-in-workers-why-you-should-never-use-it/) for details.

## 2025-06-04

* Updated v8 to version 13.8.

## 2025-05-27

* Historically, in some cases, the same instance of `ctx` would be passed to multiple invocations of the event handler. We now always pass a new object for each event. We made this change retroactive to all compatibility dates because we suspect it fixes security bugs in some workers and does not break any worker. However, the old behavior can be restored using the compat flag `nonclass_entrypoint_reuses_ctx_across_invocations`.

## 2025-05-22

* Enabled explicit resource context management and support for Float16Array

## 2025-05-20

* Updated v8 to version 13.7.

## 2025-04-16

* Updated v8 to version 13.6.

## 2025-04-14

* JSRPC message size limit has been increased to 32MiB.

## 2025-04-03

* Websocket client exceptions are now JS exceptions rather than internal errors.

## 2025-03-27

* Updated v8 to version 13.5.

## 2025-02-28

* Updated v8 to version 13.4.
* When using `nodejs_compat`, the new `nodejs_compat_populate_process_env` compatibility flag will cause `process.env` to be automatically populated with text bindings configured for the worker.

## 2025-02-26

* [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/builds/) now supports building projects that use **pnpm 10** as the package manager. If your build previously failed due to this unsupported version, retry your build. No config changes needed.

## 2025-02-13

* [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement/) no longer runs Workers in the same location as D1 databases they are bound to. The same [placement logic](https://developers.cloudflare.com/workers/configuration/smart-placement/#understand-how-smart-placement-works) now applies to all Workers that use Smart Placement, regardless of whether they use D1 bindings.

## 2025-02-11

* When Workers generate an "internal error" exception in response to certain failures, the exception message may provide a reference ID that customers can include in support communication for easier error identification. For example, an exception with the new message might look like: `internal error; reference = 0123456789abcdefghijklmn`.

## 2025-01-31

* Updated v8 to version 13.3.

## 2025-01-15

* The runtime will no longer reuse isolates across worker versions even if the code happens to be identical. This "optimization" was deemed more confusing than it is worth.

## 2025-01-14

* Updated v8 to version 13.2.

## 2024-12-19

* **Cloudflare GitHub App Permissions Update**

  * Cloudflare is requesting updated permissions for the [Cloudflare GitHub App](https://github.com/apps/cloudflare-workers-and-pages) to enable features like automatically creating a repository on your GitHub account and deploying the new repository for you when getting started with a template. This feature is coming out soon to support a better onboarding experience.

  * **Requested permissions:**

    * [Repository Administration](https://docs.github.com/en/rest/authentication/permissions-required-for-github-apps?apiVersion=2022-11-28#repository-permissions-for-administration) (read/write) to create repositories.
    * [Contents](https://docs.github.com/en/rest/authentication/permissions-required-for-github-apps?apiVersion=2022-11-28#repository-permissions-for-contents) (read/write) to push code to the created repositories.

  * **Who is impacted:**

    * Existing users will be prompted to update permissions when GitHub sends an email with subject "\[GitHub] Cloudflare Workers & Pages is requesting updated permission" on December 19th, 2024.
    * New users installing the app will see the updated permissions during the connecting repository process.

  * **Action:** Review and accept the permissions update to use upcoming features. *If you decline or take no action, you can continue connecting repositories and deploying changes via the Cloudflare GitHub App as you do today, but new features requiring these permissions will not be available.*

  * **Questions?** Visit [#github-permissions-update](https://discord.com/channels/595317990191398933/1313895851520688163) in the Cloudflare Developers Discord.

## 2024-11-18

* Updated v8 to version 13.1.

## 2024-11-12

* Fixes exception seen when trying to call deleteAll() during a SQLite-backed Durable Object's alarm handler.

## 2024-11-08

* Update SQLite to version 3.47.

## 2024-10-21

* Fixed encoding of WebSocket pong messages when talking to remote servers. Previously, when a Worker made a WebSocket connection to an external server, the server may have prematurely closed the WebSocket for failure to respond correctly to pings. Client-side connections were not affected.

## 2024-10-14

* Updated v8 to version 13.0.

## 2024-09-26

* You can now connect your GitHub or GitLab repository to an existing Worker to automatically build and deploy your changes when you make a git push with [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/builds/).

## 2024-09-20

* Workers now support the \[`handle_cross_request_promise_resolution`] compatibility flag which addresses certain edge cases around awaiting and resolving promises across multiple requests.

## 2024-09-19

* Revamped Workers and Pages UI settings to simplify the creation and management of project configurations. For bugs and general feedback, please submit this [form](https://forms.gle/XXqhRGbZmuzninuN9).

## 2024-09-16

* Updated v8 to version 12.9.

## 2024-08-19

* Workers now support the [`allow_custom_ports` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#allow-specifying-a-custom-port-when-making-a-subrequest-with-the-fetch-api) which enables using the `fetch()` calls to custom ports.

## 2024-08-15

* Updated v8 to version 12.8.
* You can now use [`Promise.try()`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/try) in Cloudflare Workers. Refer to [`tc39/proposal-promise-try`](https://github.com/tc39/proposal-promise-try) for more context on this API that has recently been added to the JavaScript language.

## 2024-08-14

* When using the `nodejs_compat_v2` compatibility flag, the `setImmediate(fn)` API from Node.js is now available at the global scope.
* The `internal_writable_stream_abort_clears_queue` compatibility flag will ensure that certain `WritableStream` `abort()` operations are handled immediately rather than lazily, ensuring that the stream is appropriately aborted when the consumer of the stream is no longer active.

## 2024-07-19

* Workers with the [mTLS](https://developers.cloudflare.com/workers/runtime-apis/bindings/mtls/) binding now support [Gradual Deployments](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/gradual-deployments/).

## 2024-07-18

* Added a new `truncated` flag to [Tail Worker](https://developers.cloudflare.com/workers/observability/logs/tail-workers/) events to indicate when the event buffer is full and events are being dropped.

## 2024-07-17

* Updated v8 to version 12.7.

## 2024-07-11

* Added community contributed tutorial on how to create [custom access control for files in R2 using D1 and Workers](https://web.archive.org/web/20250714020752/https://developers.cloudflare.com/developer-spotlight/tutorials/custom-access-control-for-files/).
* Added community contributed tutorial on how to [send form submissions using Astro and Resend](https://web.archive.org/web/20250715071959/https://developers.cloudflare.com/developer-spotlight/tutorials/handle-form-submission-with-astro-resend/).
* Added community contributed tutorial on how to [create a sitemap from Sanity CMS with Workers](https://web.archive.org/web/20250713111832/https://developers.cloudflare.com/developer-spotlight/tutorials/create-sitemap-from-sanity-cms/).

## 2024-07-03

* The [`node:crypto`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/crypto/) implementation now includes the scrypt(...) and scryptSync(...) APIs.
* Workers now support the standard [EventSource](https://developers.cloudflare.com/workers/runtime-apis/eventsource/) API.
* Fixed a bug where when writing to an HTTP Response body would sometimes hang when the client disconnected (and sometimes throw an exception). It will now always throw an exception.

## 2024-07-01

* When using [Gradual Deployments](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/gradual-deployments/), you can now use [version overrides](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/gradual-deployments/#version-overrides) to send a request to a specific version of your Worker.

## 2024-06-28

* Fixed a bug which caused `Date.now()` to return skewed results if called before the first I/O of the first request after a Worker first started up. The value returned would be offset backwards by the amount of CPU time spent starting the Worker (compiling and running global scope), making it seem like the first I/O (e.g. first fetch()) was slower than it really was. This skew had nothing to do with Spectre mitigations; it was simply a longstanding bug.

## 2024-06-24

* [Exceptions](https://developers.cloudflare.com/durable-objects/best-practices/error-handling) thrown from Durable Object internal operations and tunneled to the caller may now be populated with a `.retryable: true` property if the exception was likely due to a transient failure, or populated with an `.overloaded: true` property if the exception was due to [overload](https://developers.cloudflare.com/durable-objects/observability/troubleshooting/#durable-object-is-overloaded).

## 2024-06-20

* We now prompt for extra confirmation if attempting to rollback to a version of a Worker using the [Deployments API](https://developers.cloudflare.com/api/resources/workers/subresources/scripts/subresources/deployments/methods/create/) where the value of a secret is different than the currently deployed version. A `?force=true` query parameter can be specified to proceed with the rollback.

## 2024-06-19

* When using [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/runtime-apis/nodejs/), the `buffer` module now has an implementation of `isAscii()` and `isUtf8()` methods.
* Fixed a bug where exceptions propagated from [JS RPC](https://developers.cloudflare.com/workers/runtime-apis/rpc) calls to Durable Objects would lack the `.remote` property that exceptions from `fetch()` calls to Durable Objects have.

## 2024-06-12

* Blob and Body objects now include a new `bytes()` method, reflecting [recent](https://w3c.github.io/FileAPI/#bytes-method-algo) [additions](https://fetch.spec.whatwg.org/#dom-body-bytes) to web standards.

## 2024-06-03

* Workers with [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement/) enabled now support [Gradual Deployments](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/gradual-deployments/).

## 2024-05-17

* Updated v8 to version 12.6.

## 2024-05-15

* The new [`fetch_standard_url` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#use-standard-url-parsing-in-fetch) will become active by default on June 3rd, 2024 and ensures that URLs passed into the `fetch(...)` API, the `new Request(...)` constructor, and redirected requests will be parsed using the standard WHATWG URL parser.
* DigestStream is now more efficient and exposes a new `bytesWritten` property that indicates that number of bytes written to the digest.

## 2024-05-13

* Updated v8 to version 12.5.
* A bug in the fetch API implementation would cause the content type of a Blob to be incorrectly set. The fix is being released behind a new [`blob_standard_mime_type` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#properly-extract-blob-mime-type-from-content-type-headers).

## 2024-05-03

* Fixed RPC to/from Durable Objects not honoring the output gate.
* The `internal_stream_byob_return_view` compatibility flag can be used to improve the standards compliance of the `ReadableStreamBYOBReader` implementation when working with BYOB streams provided by the runtime (like in `response.body` or `request.body`). The flag ensures that the final read result will always include a `value` field whose value is set to an empty `Uint8Array` whose underlying `ArrayBuffer` is the same memory allocation as the one passed in on the call to `read()`.
* The Web platform standard `reportError(err)` global API is now available in workers. The reported error will first be emitted as an 'error' event on the global scope then reported in both the console output and tail worker exceptions by default.

## 2024-04-26

* Updated v8 to version 12.4.

## 2024-04-11

* Improve Streams API spec compliance by exposing `desiredSize` and other properties on stream class prototypes
* The new `URL.parse(...)` method is implemented. This provides an alternative to the URL constructor that does not throw exceptions on invalid URLs.
* R2 bindings objects now have a `storageClass` option. This can be set on object upload to specify the R2 storage class - Standard or Infrequent Access. The property is also returned with object metadata.

## 2024-04-05

* A new [JavaScript-native remote procedure call (RPC) API](https://developers.cloudflare.com/workers/runtime-apis/rpc) is now available, allowing you to communicate more easily across Workers and between Workers and Durable Objects.

## 2024-04-04

* There is no longer an explicit limit on the total amount of data which may be uploaded with Cache API [`put()`](https://developers.cloudflare.com/workers/runtime-apis/cache/#put) per request. Other [Cache API Limits](https://developers.cloudflare.com/workers/platform/limits/#cache-api-limits) continue to apply.
* The Web standard `ReadableStream.from()` API is now implemented. The API enables creating a `ReadableStream` from a either a sync or async iterable.

## 2024-04-03

* When the [`brotli_content_encoding`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#brotli-content-encoding-support) compatibility flag is enabled, the Workers runtime now supports compressing and decompressing request bodies encoded using the [Brotli](https://developer.mozilla.org/en-US/docs/Glossary/Brotli_compression) compression algorithm. Refer to [this docs section](https://developers.cloudflare.com/workers/runtime-apis/fetch/#how-the-accept-encoding-header-is-handled) for more detail.

## 2024-04-02

* You can now [write Workers in Python](https://developers.cloudflare.com/workers/languages/python)

## 2024-04-01

* The new [`unwrap_custom_thenables` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#handling-custom-thenables) enables workers to accept custom thenables in internal APIs that expect a promise (for instance, the `ctx.waitUntil(...)` method).
* TransformStreams created with the TransformStream constructor now have a cancel algorithm that is called when the stream is canceled or aborted. This change is part of the implementation of the WHATWG Streams standard.
* The [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/runtime-apis/nodejs/) now includes an implementation of the [`MockTracker` API from `node:test`](https://nodejs.org/api/test.html#class-mocktracker). This is not an implementation of the full `node:test` module, and mock timers are currently not included.
* Exceptions reported to [Tail Workers](https://developers.cloudflare.com/workers/observability/logs/tail-workers/) now include a "stack" property containing the exception's stack trace, if available.

## 2024-03-11

* Built-in APIs that return Promises will now produce stack traces when the Promise rejects. Previously, the rejection error lacked a stack trace.
* A new compat flag `fetcher_no_get_put_delete` removes the `get()`, `put()`, and `delete()` methods on service bindings and Durable Object stubs. This will become the default as of compatibility date 2024-03-26. These methods were designed as simple convenience wrappers around `fetch()`, but were never documented.
* Updated v8 to version 12.3.

## 2024-02-24

* v8 updated to version 12.2.
* You can now use [Iterator helpers](https://v8.dev/features/iterator-helpers) in Workers.
* You can now use [new methods on `Set`](https://github.com/tc39/proposal-set-methods), such as `Set.intersection` and `Set.union`, in Workers.

## 2024-02-23

* Sockets now support an [`opened`](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/#socket) attribute.
* [Durable Object alarm handlers](https://developers.cloudflare.com/durable-objects/api/alarms/#alarm) now impose a maximum wall time of 15 minutes.

## 2023-12-04

* The Web Platform standard [`navigator.sendBeacon(...)` API](https://developers.cloudflare.com/workers/runtime-apis/web-standards#navigatorsendbeaconurl-data) is now provided by the Workers runtime.
* V8 updated to 12.0.

## 2023-10-30

* A new usage model called [Workers Standard](https://developers.cloudflare.com/workers/platform/pricing/#workers) is available for Workers and Pages Functions pricing. This is now the default usage model for accounts that are first upgraded to the Workers Paid plan. Read the [blog post](https://blog.cloudflare.com/workers-pricing-scale-to-zero/) for more information.
* The usage model set in a script's wrangler.toml will be ignored after an account has opted-in to [Workers Standard](https://developers.cloudflare.com/workers/platform/pricing/#workers) pricing. It must be configured through the dashboard (Workers & Pages > Select your Worker > Settings > Usage Model).
* Workers and Pages Functions on the Standard usage model can set custom [CPU limits](https://developers.cloudflare.com/workers/wrangler/configuration/#limits) for their Workers

## 2023-10-20

* Added the [`crypto_preserve_public_exponent`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#webcrypto-preserve-publicexponent-field) compatibility flag to correct a wrong type being used in the algorithm field of RSA keys in the WebCrypto API.

## 2023-10-18

* The limit of 3 Cron Triggers per Worker has been removed. Account-level limits on the total number of Cron Triggers across all Workers still apply.

## 2023-10-12

* A [TCP Socket](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/)'s WritableStream now ensures the connection has opened before resolving the promise returned by `close`.

## 2023-10-09

* The Web Platform standard [`CustomEvent` class](https://dom.spec.whatwg.org/#interface-customevent) is now available in Workers.
* Fixed a bug in the WebCrypto API where the `publicExponent` field of the algorithm of RSA keys would have the wrong type. Use the [`crypto_preserve_public_exponent` compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#webcrypto-preserve-publicexponent-field) to enable the new behavior.

## 2023-09-14

* An implementation of the [`node:crypto`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/crypto/) API from Node.js is now available when the [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/runtime-apis/nodejs/) is enabled.

## 2023-07-14

* An implementation of the [`util.MIMEType`](https://nodejs.org/api/util.html#class-utilmimetype) API from Node.js is now available when the [`nodejs_compat` compatibility flag](https://developers.cloudflare.com/workers/runtime-apis/nodejs/) is enabled.

## 2023-07-07

* An implementation of the [`process.env`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/process) API from Node.js is now available when using the `nodejs_compat` compatibility flag.
* An implementation of the [`diagnostics_channel`](https://developers.cloudflare.com/workers/runtime-apis/nodejs/diagnostics-channel) API from Node.js is now available when using the `nodejs_compat` compatibility flag.

## 2023-06-22

* Added the [`strict_crypto_checks`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#strict-crypto-error-checking) compatibility flag to enable additional [Web Crypto API](https://developers.cloudflare.com/workers/runtime-apis/web-crypto/) error and security checking.
* Fixes regression in the [TCP Sockets API](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/) where `connect("google.com:443")` would fail with a `TypeError`.

## 2023-06-19

* The [TCP Sockets API](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/) now reports clearer errors when a connection cannot be established.
* Updated V8 to 11.5.

## 2023-06-09

* `AbortSignal.any()` is now available.
* Updated V8 to 11.4.
* Following an update to the [WHATWG URL spec](https://url.spec.whatwg.org/#interface-urlsearchparams), the `delete()` and `has()` methods of the `URLSearchParams` class now accept an optional second argument to specify the search parameter’s value. This is potentially a breaking change, so it is gated behind the new `urlsearchparams_delete_has_value_arg` and [`url_standard`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#new-url-parser-implementation) compatibility flags.
* Added the [`strict_compression_checks`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#strict-compression-error-checking) compatibility flag for additional [`DecompressionStream`](https://developers.cloudflare.com/workers/runtime-apis/web-standards/#compression-streams) error checking.

## 2023-05-26

* A new [Hibernatable WebSockets API](https://developers.cloudflare.com/durable-objects/best-practices/websockets/) (beta) has been added to [Durable Objects](https://developers.cloudflare.com/durable-objects/). The Hibernatable WebSockets API allows a Durable Object that is not currently running an event handler (for example, processing a WebSocket message or alarm) to be removed from memory while keeping its WebSockets connected (“hibernation”). A Durable Object that hibernates will not incur billable Duration (GB-sec) charges.

## 2023-05-16

* The [new `connect()` method](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/) allows you to connect to any TCP-speaking services directly from your Workers. To learn more about other protocols supported on the Workers platform, visit the [new Protocols documentation](https://developers.cloudflare.com/workers/reference/protocols/).
* We have added new [native database integrations](https://developers.cloudflare.com/workers/databases/native-integrations/) for popular serverless database providers, including Neon, PlanetScale, and Supabase. Native integrations automatically handle the process of creating a connection string and adding it as a Secret to your Worker.
* You can now also connect directly to databases over TCP from a Worker, starting with [PostgreSQL](https://developers.cloudflare.com/hyperdrive/examples/connect-to-postgres/). Support for PostgreSQL is based on the popular `pg` driver, and allows you to connect to any PostgreSQL instance over TLS from a Worker directly.
* The [R2 Migrator](https://developers.cloudflare.com/r2/data-migration/) (Super Slurper), which automates the process of migrating from existing object storage providers to R2, is now Generally Available.

## 2023-05-15

* [Cursor](https://developers.cloudflare.com/workers/ai/), an experimental AI assistant, trained to answer questions about Cloudflare's Developer Platform, is now available to preview! Cursor can answer questions about Workers and the Cloudflare Developer Platform, and is itself built on Workers. You can read more about Cursor in the [announcement blog](https://blog.cloudflare.com/introducing-cursor-the-ai-assistant-for-docs/).

## 2023-05-12

* The [`performance.now()`](https://developer.mozilla.org/en-US/docs/Web/API/Performance/now) and [`performance.timeOrigin`](https://developer.mozilla.org/en-US/docs/Web/API/Performance/timeOrigin) APIs can now be used in Cloudflare Workers. Just like `Date.now()`, for [security reasons](https://developers.cloudflare.com/workers/reference/security-model/) time only advances after I/O.

## 2023-05-05

* The new `nodeJsCompatModule` type can be used with a Worker bundle to emulate a Node.js environment. Common Node.js globals such as `process` and `Buffer` will be present, and `require('...')` can be used to load Node.js built-ins without the `node:` specifier prefix.
* Fixed an issue where websocket connections would be disconnected when updating workers. Now, only WebSockets connected to Durable Objects are disconnected by updates to that Durable Object’s code.

## 2023-04-28

* The Web Crypto API now supports curves Ed25519 and X25519 defined in the Secure Curves specification.
* The global `connect` method has been moved to a `cloudflare:sockets` module.

## 2023-04-14

* No externally-visible changes this week.

## 2023-04-10

* `URL.canParse(...)` is a new standard API for testing that an input string can be parsed successfully as a URL without the additional cost of creating and throwing an error.
* The Workers-specific `IdentityTransformStream` and `FixedLengthStream` classes now support specifying a `highWaterMark` for the writable-side that is used for backpressure signaling using the standard `writer.desiredSize`/`writer.ready` mechanisms.

## 2023-03-24

* Fixed a bug in Wrangler tail and live logs on the dashboard that prevented the Administrator Read-Only and Workers Tail Read roles from successfully tailing Workers.

## 2023-03-09

* No externally-visible changes.

## 2023-03-06

* [Workers Logpush](https://developers.cloudflare.com/workers/observability/logs/logpush/#limits) now supports 300 characters per log line. This is an increase from the previous limit of 150 characters per line.

## 2023-02-06

* Fixed a bug where transferring large request bodies to a Durable Object was unexpectedly slow.
* Previously, an error would be thrown when trying to access unimplemented standard `Request` and `Response` properties. Now those will be left as `undefined`.

## 2023-01-31

* The [`request.cf`](https://developers.cloudflare.com/workers/runtime-apis/request/#incomingrequestcfproperties) object now includes two additional properties, `tlsClientHelloLength` and `tlsClientRandom`.

## 2023-01-13

* Durable Objects can now use jurisdictions with `idFromName` via a new subnamespace API.
* V8 updated to 10.9.
