---
title: JavaScript and web standards · Cloudflare Workers docs
description: Standardized APIs for use by Workers running on Cloudflare's global network.
lastUpdated: 2024-11-07T19:39:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/runtime-apis/web-standards/
  md: https://developers.cloudflare.com/workers/runtime-apis/web-standards/index.md
---

***

## JavaScript standards

The Cloudflare Workers runtime is [built on top of the V8 JavaScript and WebAssembly engine](https://developers.cloudflare.com/workers/reference/how-workers-works/). The Workers runtime is updated at least once a week, to at least the version of V8 that is currently used by Google Chrome's stable release. This means you can safely use the latest JavaScript features, with no need for transpilers.

All of the [standard built-in objects](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference) supported by the current Google Chrome stable release are supported, with a few notable exceptions:

* For security reasons, the following are not allowed:

  * `eval()`
  * `new Function`
  * [`WebAssembly.compile`](https://developer.mozilla.org/en-US/docs/WebAssembly/JavaScript_interface/compile_static)
  * [`WebAssembly.compileStreaming`](https://developer.mozilla.org/en-US/docs/WebAssembly/JavaScript_interface/compileStreaming_static)
  * `WebAssembly.instantiate` with a [buffer parameter](https://developer.mozilla.org/en-US/docs/WebAssembly/JavaScript_interface/instantiate_static#primary_overload_%E2%80%94_taking_wasm_binary_code)
  * [`WebAssembly.instantiateStreaming`](https://developer.mozilla.org/en-US/docs/WebAssembly/JavaScript_interface/instantiateStreaming_static)

* `Date.now()` returns the time of the last I/O; it does not advance during code execution.

***

## Web standards and global APIs

The following methods are available per the [Worker Global Scope](https://developer.mozilla.org/en-US/docs/Web/API/WorkerGlobalScope):

### Base64 utility methods

* atob()

  * Decodes a string of data which has been encoded using base-64 encoding.

* btoa()

  * Creates a base-64 encoded ASCII string from a string of binary data.

### Timers

* setInterval()

  * Schedules a function to execute every time a given number of milliseconds elapses.

* clearInterval()

  * Cancels the repeated execution set using [`setInterval()`](https://developer.mozilla.org/en-US/docs/Web/API/setInterval).

* setTimeout()

  * Schedules a function to execute in a given amount of time.

* clearTimeout()

  * Cancels the delayed execution set using [`setTimeout()`](https://developer.mozilla.org/en-US/docs/Web/API/setTimeout).

Note

Timers are only available inside of [the Request Context](https://developers.cloudflare.com/workers/runtime-apis/request/#the-request-context).

### `performance.timeOrigin` and `performance.now()`

* performance.timeOrigin

  * Returns the high resolution time origin. Workers uses the UNIX epoch as the time origin, meaning that `performance.timeOrigin` will always return `0`.

* performance.now()

  * Returns a `DOMHighResTimeStamp` representing the number of milliseconds elapsed since `performance.timeOrigin`. Note that Workers intentionally reduces the precision of `performance.now()` such that it returns the time of the last I/O and does not advance during code execution. Effectively, because of this, and because `performance.timeOrigin` is always, `0`, `performance.now()` will always equal `Date.now()`, yielding a consistent view of the passage of time within a Worker.

### `EventTarget` and `Event`

The [`EventTarget`](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget) and [`Event`](https://developer.mozilla.org/en-US/docs/Web/API/Event) API allow objects to publish and subscribe to events.

### `AbortController` and `AbortSignal`

The [`AbortController`](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) and [`AbortSignal`](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) APIs provide a common model for canceling asynchronous operations.

### Fetch global

* fetch()

  * Starts the process of fetching a resource from the network. Refer to [Fetch API](https://developers.cloudflare.com/workers/runtime-apis/fetch/).

Note

The Fetch API is only available inside of [the Request Context](https://developers.cloudflare.com/workers/runtime-apis/request/#the-request-context).

***

## Encoding API

Both `TextEncoder` and `TextDecoder` support UTF-8 encoding/decoding.

[Refer to the MDN documentation for more information](https://developer.mozilla.org/en-US/docs/Web/API/Encoding_API).

The [`TextEncoderStream`](https://developer.mozilla.org/en-US/docs/Web/API/TextEncoderStream) and [`TextDecoderStream`](https://developer.mozilla.org/en-US/docs/Web/API/TextDecoderStream) classes are also available.

***

## URL API

The URL API supports URLs conforming to HTTP and HTTPS schemes.

[Refer to the MDN documentation for more information](https://developer.mozilla.org/en-US/docs/Web/API/URL)

Note

The default URL class behavior differs from the URL Spec documented above.

A new spec-compliant implementation of the URL class can be enabled using the `url_standard` [compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-flags/).

***

## Compression Streams

The `CompressionStream` and `DecompressionStream` classes support the deflate, deflate-raw and gzip compression methods.

[Refer to the MDN documentation for more information](https://developer.mozilla.org/en-US/docs/Web/API/Compression_Streams_API)

***

## URLPattern API

The `URLPattern` API provides a mechanism for matching URLs based on a convenient pattern syntax.

[Refer to the MDN documentation for more information](https://developer.mozilla.org/en-US/docs/Web/API/URLPattern).

***

## `Intl`

The `Intl` API allows you to format dates, times, numbers, and more to the format that is used by a provided locale (language and region).

[Refer to the MDN documentation for more information](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl).

***

## `navigator.userAgent`

When the [`global_navigator`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#global-navigator) compatibility flag is set, the [`navigator.userAgent`](https://developer.mozilla.org/en-US/docs/Web/API/Navigator/userAgent) property is available with the value `'Cloudflare-Workers'`. This can be used, for example, to reliably determine that code is running within the Workers environment.

## Unhandled promise rejections

The [`unhandledrejection`](https://developer.mozilla.org/en-US/docs/Web/API/Window/unhandledrejection_event) event is emitted by the global scope when a JavaScript promise is rejected without a rejection handler attached.

The [`rejectionhandled`](https://developer.mozilla.org/en-US/docs/Web/API/Window/rejectionhandled_event) event is emitted by the global scope when a JavaScript promise rejection is handled late (after a rejection handler is attached to the promise after an `unhandledrejection` event has already been emitted).

```js
addEventListener('unhandledrejection', (event) => {
  console.log(event.promise);  // The promise that was rejected.
  console.log(event.reason);  // The value or Error with which the promise was rejected.
});


addEventListener('rejectionhandled', (event) => {
  console.log(event.promise);  // The promise that was rejected.
  console.log(event.reason);  // The value or Error with which the promise was rejected.
});
```

***

## `navigator.sendBeacon(url[, data])`

When the [`global_navigator`](https://developers.cloudflare.com/workers/configuration/compatibility-flags/#global-navigator) compatibility flag is set, the [`navigator.sendBeacon(...)`](https://developer.mozilla.org/en-US/docs/Web/API/Navigator/sendBeacon) API is available to send an HTTP `POST` request containing a small amount of data to a web server. This API is intended as a means of transmitting analytics or diagnostics information asynchronously on a best-effort basis.

For example, you can replace:

```js
const promise = fetch('https://example.com', { method: 'POST', body: 'hello world' });
ctx.waitUntil(promise);
```

with `navigator.sendBeacon(...)`:

```js
navigator.sendBeacon('https://example.com', 'hello world');
```
